<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Query to check if the index exists
        $indexExists = DB::table('INFORMATION_SCHEMA.STATISTICS')
            ->where('table_schema', env('DB_DATABASE'))
            ->where('table_name', 'addresses')
            ->where('index_name', 'addresses_email_index')
            ->exists();

        if (!$indexExists) {
            DB::statement("ALTER TABLE addresses ADD INDEX addresses_email_index (email(191));");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('addresses', function (Blueprint $table) {
            $table->dropIndex('addresses_email_index');
        });
    }
};
