<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('purchase_invoices', function (Blueprint $table) {
            $table->dateTime('purchase_invoice_date')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        \App\Models\Supplier::query()->each(function (\App\Models\Supplier $supplier) use ($timezone) {
            DB::statement('UPDATE purchase_invoices SET purchase_invoice_date = CONVERT_TZ(purchase_invoice_date, "UTC", "' . $timezone . '") WHERE supplier_id = ' . $supplier->id);
        });
    }
};
