<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('stock_takes', function (Blueprint $table) {
            $table->dateTime('date_count')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('stock_takes')->cursor()->each(function ($stockTake) use ($timezone) {
            $date_count = $stockTake->date_count ?
                Carbon::parse($stockTake->date_count, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('stock_takes')->where('id', $stockTake->id)->update([
                'date_count' => $date_count,
            ]);

        });
    }
};
