<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('inventory_forecasts_cache', function (Blueprint $table) {
            $table->dateTime('out_of_stock_date')->change();
            $table->dateTime('forecast_date')->change();
        });

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('inventory_forecasts_cache')->cursor()->each(function ($inventoryForecastsCache) use ($timezone) {
            $out_of_stock_date = $inventoryForecastsCache->out_of_stock_date ?
                Carbon::parse($inventoryForecastsCache->out_of_stock_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            $forecast_date = $inventoryForecastsCache->forecast_date ?
                Carbon::parse($inventoryForecastsCache->forecast_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('inventory_forecasts_cache')->where('id', $inventoryForecastsCache->id)->update([
                'out_of_stock_date' => $out_of_stock_date,
                'forecast_date' => $forecast_date,
            ]);

        });
    }
};
