<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('shopify_orders', function (Blueprint $table) {
            $table->string('financial_status')->nullable()->after('error_log')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(`json_object`, "$.financial_status"))');
            $table->string('fulfillment_status')->nullable()->after('financial_status')->storedAs('JSON_UNQUOTE(JSON_EXTRACT(`json_object`, "$.fulfillment_status"))');
        });
    }

    public function down(): void
    {
        Schema::table('shopify_orders', function (Blueprint $table) {
            $table->dropColumn('financial_status');
            $table->dropColumn('fulfillment_status');
        });
    }
};
