<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('amazon_financial_event_groups', function (Blueprint $table) {
            $table->index(['integration_instance_id', 'ProcessingStatus'], 'amazon_financial_event_groups_integration_status_index');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('amazon_financial_event_groups', function (Blueprint $table) {
            $table->dropIndex('amazon_financial_event_groups_integration_status_index');
        });
    }
};
