<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('amazon_orders', function (Blueprint $table) {
            $table->string('error_log')->nullable()->after('sync_status');
        });

        Schema::table('woo_commerce_orders', function (Blueprint $table) {
            $table->string('error_log')->nullable()->after('sync_status');
        });

        Schema::table('shopify_orders', function (Blueprint $table) {
            $table->string('error_log')->nullable()->after('sync_status');
        });

        DB::statement('UPDATE amazon_orders SET error_log = sync_status');
        DB::statement('UPDATE shopify_orders SET error_log = sync_status');
        DB::statement('UPDATE woo_commerce_orders SET error_log = sync_status');

        Schema::table('amazon_orders', function (Blueprint $table) {
            $table->string('sync_status')->nullable()->change();
        });

        Schema::table('woo_commerce_orders', function (Blueprint $table) {
            $table->string('sync_status')->nullable()->change();
        });

        Schema::table('shopify_orders', function (Blueprint $table) {
            $table->string('sync_status')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('amazon_orders', function (Blueprint $table) {
            $table->dropColumn('error_log');
        });

        Schema::table('woo_commerce_orders', function (Blueprint $table) {
            $table->dropColumn('error_log');
        });

        Schema::table('shopify_orders', function (Blueprint $table) {
            $table->dropColumn('error_log');
        });
    }
};
