<?php

use App\Helpers;
use App\Models\Setting;
use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('purchase_orders', function (Blueprint $table) {
            $table->dateTime('estimated_delivery_date')->change();
            $table->dateTime('other_date')->change();
        });

        /*
        |--------------------------------------------------------------------------
        | Convert date format assumed to be in local timezone to UTC (app.timezone)
        |--------------------------------------------------------------------------
        */

        $timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, config('app.timezone'));
        DB::table('purchase_orders')->cursor()->each(function ($purchaseOrder) use ($timezone) {
            $estimatedDeliveryDate = $purchaseOrder->estimated_delivery_date ?
                Carbon::parse($purchaseOrder->estimated_delivery_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            $otherDate = $purchaseOrder->other_date ?
                Carbon::parse($purchaseOrder->other_date, $timezone)
                    ->timezone(config('app.timezone')) :
                null;
            DB::table('purchase_orders')->where('id', $purchaseOrder->id)->update([
                'estimated_delivery_date' => $estimatedDeliveryDate,
                'other_date' => $otherDate,
            ]);

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
};
