<?php

namespace Database\Factories;

use App\Models\WarehouseTransferLine;
use App\Models\WarehouseTransferShipment;
use App\Models\WarehouseTransferShipmentLine;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class WarehouseTransferShipmentLineFactory extends Factory
{
    protected $model = WarehouseTransferShipmentLine::class;

    public function definition(): array
    {
        return [
            'quantity' => $this->faker->randomNumber(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
            'warehouse_transfer_shipment_id' => WarehouseTransferShipment::factory(),
            'warehouse_transfer_line_id' => WarehouseTransferLine::factory(),
        ];
    }
}
