<?php

namespace Database\Factories;

use App\Models\ShippingMethod;
use App\Models\WarehouseTransfer;
use App\Models\WarehouseTransferShipment;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class WarehouseTransferShipmentFactory extends Factory
{
    protected $model = WarehouseTransferShipment::class;

    public function definition(): array
    {
        return [
            //'cost' => $this->faker->randomFloat(),
            'tracking_number' => $this->faker->word(),
            'shipped_at' => Carbon::now(),
            'fully_received_at' => Carbon::now(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),

            'shipping_method_id' => ShippingMethod::factory(),
            'warehouse_transfer_id' => WarehouseTransfer::factory(),
        ];
    }
}
