<?php

namespace Database\Factories;

use App\Models\Address;
use App\Models\Warehouse;
use Closure;
use Illuminate\Database\Eloquent\Factories\Factory;

// archived product
// unarchived product

// create warehouse with location

class WarehouseFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->unique()->word(),
            'type' => Warehouse::TYPE_DIRECT,
            'address_id' => Address::factory(),
            'dropship_enabled' => false,
            'supplier_id' => null,
        ];
    }

    public function direct(): self
    {
        return $this->state(function () {
            return [
                'type' => Warehouse::TYPE_DIRECT,
            ];
        });
    }

    public function archived()
    {
        return $this->state(function () {
            return [
                'archived_at' => $this->faker->dateTimeThisMonth(),
            ];
        });
    }

    public function unarchived()
    {
        return $this->state(['archived_at' => null]);
    }
}
