<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\Supplier;
use App\Models\SupplierInventory;
use App\Models\SupplierPricingTier;
use App\Models\SupplierProduct;
use App\Models\SupplierProductPricing;
use Database\Factories\Concerns\HasFactoryDataRecycler;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SupplierProduct>
 */
class SupplierProductFactory extends Factory
{
    use HasFactoryDataRecycler;

    public function definition(): array
    {
        return [
            'supplier_id' => Supplier::factory()->withWarehouse()->withAddress(),
            'product_id' => Product::factory(),
            'is_default' => 1,
        ];
    }

    public function configure(): self
    {
        return $this->afterCreating(function (SupplierProduct $supplierProduct) {
            SupplierInventory::factory()->create([
                'product_id' => $supplierProduct->product_id,
                'supplier_id' => $supplierProduct->supplier_id,
                'warehouse_id' => $supplierProduct->supplier->default_warehouse_id,
            ]);
            SupplierProductPricing::factory()->create([
                'supplier_product_id' => $supplierProduct->id,
                'supplier_pricing_tier_id' => SupplierPricingTier::query()->first()->id,
            ]);
        });
    }
}
