<?php

namespace Database\Factories;

use App\Models\Address;
use App\Models\Supplier;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Factories\Factory;

class SupplierFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->unique()->name(),
            'company_name' => $this->faker->unique()->company(),
            'primary_contact_name' => $this->faker->name(),
            'email' => $this->faker->email(),
            'purchase_order_email' => $this->faker->companyEmail(),
            'website' => $this->faker->url(),
            'leadtime' => $this->faker->randomNumber(1),
            'minimum_order_quantity' => $this->faker->randomNumber(2),
            'minimum_purchase_order' => $this->faker->randomNumber(2),
            'default_warehouse_id' => Warehouse::factory(),
            'timezone' => $this->faker->timezone(),
        ];
    }

    public function withWarehouse(): self
    {
        return $this->afterCreating(function (Supplier $supplier) {
            /** @var Warehouse $warehouse */
            $warehouse = Warehouse::factory()->create([
                'supplier_id' => $supplier->id,
                'type' => Warehouse::TYPE_SUPPLIER,
            ]);

            $supplier->update([
                'default_warehouse_id' => $warehouse->id,
            ]);
        });
    }

    public function withAddress()
    {
        return $this->afterCreating(function (Supplier $supplier) {
            $address = Address::factory()->create(['country' => $this->faker->countryCode()]);

            $supplier->update(['address_id' => $address->id]);
        });
    }
}
