<?php

namespace Database\Factories;

use App\Models\InventoryMovement;
use App\Models\Product;
use App\Models\StockTake;
use App\Models\StockTakeItem;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\StockTakeItem>
 */
class StockTakeItemFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'stock_take_id' => StockTake::factory(),
            'product_id' => Product::factory(),
            'snapshot_inventory' => $this->faker->randomElement([0, 3]),
            'qty_counted' => $this->faker->numberBetween(5, 8),
        ];
    }

    public function withInventoryMovement()
    {
        /** @var StockTakeItem $stockTakeItem */
        $stockTakeItem = $this->getRawAttributes(new StockTakeItem());

        $adjustmentQuantity = $stockTakeItem['qty_counted'] - $stockTakeItem['snapshot_inventory'];

        if ($adjustmentQuantity > 0) {
            return
                $this->has(
                    InventoryMovement::factory()
                        ->state(function ($attributes, StockTakeItem $stockTakeItem) use ($adjustmentQuantity) {
                            return [
                                'inventory_movement_date' => $stockTakeItem->stockTake->date_count,
                                'link_type' => StockTakeItem::class,
                                'link_id' => $stockTakeItem->id,
                                'quantity' => $adjustmentQuantity,
                                'type' => InventoryMovement::TYPE_STOCK_TAKE,
                                'inventory_status' => InventoryMovement::INVENTORY_STATUS_ACTIVE,
                                'product_id' => $stockTakeItem->product->id,
                            ];
                        })
                );
        } elseif ($adjustmentQuantity < 0) {
            //TODO: Need to consume fifo layer as opposed to create one in inventory movement factory
        }
    }
}
