<?php

namespace Database\Factories\Shopify;

use App\Models\Shopify\ShopifyWebhookEvent;
use Illuminate\Database\Eloquent\Factories\Factory;

class ShopifyWebhookEventFactory extends Factory
{
    protected $model = ShopifyWebhookEvent::class;

    public function definition(): array
    {
        return [
            'topic' => $this->faker->word,
            'unique_id' => $this->faker->unique()->uuid,
            'payload_date' => $this->faker->dateTime,
            'processed_at' => $this->faker->dateTime,
            'json_data' => json_encode($this->faker->word),
        ];
    }
}
