<?php

namespace Database\Factories\ShipStation;

use App\Models\ShipStation\ShipstationWarehouse;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ShipStation\ShipstationWarehouse>
 */
class ShipstationWarehouseFactory extends Factory
{

    protected $model = ShipstationWarehouse::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {

        $isDefault = $this->faker->randomElement([true, false]);

        return [
            'shipstation_id' => $this->faker->unique()->numberBetween(100, 10000),
            'name' => $this->faker->company(),
            'json_object' => [
                'warehouseId' => $this->faker->unique()->numberBetween(100, 10000),
                'warehouseName' => $this->faker->company(),
                'originalAddress' => [
                    'name' => $this->faker->company(),
                    'street1' => $this->faker->streetName()
                ],
                'returnAddress' => [
                    'name' => $this->faker->company(),
                    'street1' => $this->faker->streetName()
                ],
                'isDefault' => $isDefault,
            ],
            'is_default' => $isDefault,

        ];
    }
}
