<?php

namespace Database\Factories;

use App\Models\SalesOrderFulfillment;
use App\Models\SalesOrderLine;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\SalesOrderFulfillmentLine>
 */
class SalesOrderFulfillmentLineFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'sales_order_fulfillment_id' => SalesOrderFulfillment::factory(),
            'sales_order_line_id' => SalesOrderLine::factory(),
            'quantity' => $this->faker->numberBetween(1, 10),
        ];
    }
}
