<?php

namespace Database\Factories;

use App\Enums\SalesChannelFieldDefinitionDataTypeEnum;
use App\Models\SalesChannelFieldDefinition;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class SalesChannelFieldDefinitionFactory extends Factory
{
    protected $model = SalesChannelFieldDefinition::class;

    public function definition(): array
    {
        return [
            'field_name' => $this->faker->name(),
            'data_type' => $this->faker->randomElement(SalesChannelFieldDefinitionDataTypeEnum::cases()),
            'validation_rules' => $this->faker->name(),
            'sort_order' => $this->faker->numberBetween(0, 100),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
