<?php

namespace Database\Factories;

use App\Helpers;
use App\Models\Product;
use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderLine;
use App\Models\Setting;
use App\Models\SupplierProduct;
use Database\Factories\Concerns\HasFactoryDataRecycler;
use Illuminate\Database\Eloquent\Factories\Factory;
use JetBrains\PhpStorm\ArrayShape;

class PurchaseOrderLineFactory extends Factory
{
    use HasFactoryDataRecycler;

    /**
     * Define the model's default state.
     */
    #[ArrayShape(['product_id' => "\Illuminate\Support\HigherOrderCollectionProxy|mixed", 'quantity' => 'int', 'unit_cost' => 'int'])]
    public function definition(): array
    {
        return [
            'product_id' => Product::factory()->withSupplierProduct(),
            'purchase_order_id' => PurchaseOrder::factory(),
            'description' => $this->faker->sentence(),
            'nominal_code_id' => Helpers::setting(Setting::KEY_NC_MAPPING_COGS),
            'quantity' => $this->faker->numberBetween(2, 10),
            'received_quantity' => 0,
            'amount' => $this->faker->randomFloat(2, 10, 250),
            //            'unit_cost'  => $this->faker->numberBetween(10, 20),
            //        'purchase_order_id' => \App\Models\PurchaseOrder::factory()->create()->id
        ];
    }

    public function withSupplierProduct(): self
    {
        return $this->afterCreating(function (PurchaseOrderLine $line) {
            SupplierProduct::factory()->create(['product_id' => $line->product_id]);
        });
    }
}
