<?php

namespace Database\Factories;

use App\Models\PurchaseOrderLine;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PurchaseInvoiceLine>
 */
class PurchaseInvoiceLineFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'purchase_order_line_id' => PurchaseOrderLine::factory(),
            'quantity_invoiced' => $this->faker->numberBetween(1, 5),
        ];
    }
}
