<?php

namespace Database\Factories;

use App\Models\PurchaseInvoice;
use App\Models\PurchaseOrder;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\PurchaseInvoice>
 */
class PurchaseInvoiceFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'purchase_invoice_date' => $this->faker->date(),
            'supplier_invoice_number' => $this->faker->word(),
            'status' => PurchaseInvoice::STATUS_UNPAID,
            'purchase_order_id' => PurchaseOrder::factory(),
        ];
    }
}
