<?php

namespace Database\Factories;

use App\Models\Currency;
use App\Models\PaymentType;
use App\Models\SalesOrder;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class PaymentFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'link_type' => SalesOrder::class,
            'link_id' => SalesOrder::factory(),
            'payment_date' => Carbon::now()->format('Y-m-d'),
            'external_reference' => $this->faker->sha1(),
            'amount' => $this->faker->numberBetween(10, 30),
            'payment_type_id' => PaymentType::factory(),
            'currency_id' => Currency::factory(),
        ];
    }
}
