<?php

/* @var $factory Factory */

namespace Database\Factories;

use App\Models\FifoLayer;
use App\Models\InventoryMovement;
use App\Models\Product;
use App\Models\Warehouse;
use App\Models\WarehouseLocation;
use Illuminate\Database\Eloquent\Factories\Factory;

class InventoryMovementFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /*
         * We can't create an inventory movement directly and when called, link_id and link_type MUST
         * be specified
         */
        return [
            'inventory_movement_date' => $this->faker->dateTimeThisMonth(),
            'quantity' => $this->faker->numberBetween(-10, 15),
            'product_id' => Product::factory(),
            'type' => $this->faker->randomElement(InventoryMovement::TYPES),
            'inventory_status' => $this->faker->randomElement(InventoryMovement::INVENTORY_STATUS),
            'warehouse_id' => Warehouse::factory(),
            'warehouse_location_id' => function (array $inventoryMovement) {
                return WarehouseLocation::with([])->where('warehouse_id', $inventoryMovement['warehouse_id'])->first()?->id;
            },
            'layer_type' => FifoLayer::class,
            'layer_id' => function (array $inventoryMovement) {
                return FifoLayer::factory()->create([
                    'warehouse_id' => $inventoryMovement['warehouse_id'],
                    'product_id' => $inventoryMovement['product_id'],
                    'link_type' => $inventoryMovement['link_type'] ?? FifoLayer::REQUEST_LINK_TYPE_IA,
                    'link_id' => $inventoryMovement['link_id'] ?? null,
                    'original_quantity' => abs($inventoryMovement['quantity']),
                    'fulfilled_quantity' => 0,
                ])->id;
            },
        ];
    }

    // Commenting out because I want explicit control.  The following is only really used by the dummy data seeder
//    public function configure(): self
//    {
//        return $this->afterCreating(function (InventoryMovement $inventoryMovement) {
//            if ($inventoryMovement->quantity > 0) {
//                /** @var FifoLayer $fifoLayer */
//                $fifoLayer = FifoLayer::factory()->create([
//                    'warehouse_id' => $inventoryMovement->warehouse_id,
//                    'product_id' => $inventoryMovement->product_id,
//                    'link_type' => $inventoryMovement->link_type ?? FifoLayer::REQUEST_LINK_TYPE_IC,
//                    'link_id' => $inventoryMovement->link_id ?? 0,
//                    'original_quantity' => $inventoryMovement->quantity,
//                    'fulfilled_quantity' => 0,
//                ]);
//
//                $inventoryMovement->warehouse_location_id = $inventoryMovement->warehouse->defaultLocation->id;
//                $inventoryMovement->layer_id = $fifoLayer->id;
//                $inventoryMovement->layer_type = FifoLayer::class;
//                $inventoryMovement->save();
//            }
//        });
//    }
}
