<?php

namespace Database\Factories;

use App\Models\InventoryForecast;
use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\InventoryForecastItem>
 */
class InventoryForecastItemFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'inventory_forecast_id' => InventoryForecast::factory(),
            'product_id' => Product::factory(),
            'out_of_stock_date' => $this->faker->dateTime(),
            'suggested_purchase_quantity' => 10,
            'unit_cost' => 10,
            'unit_cost_in_tenant_currency' => 12,
            'tenant_currency_code' => 'USD',
            'available_stock' => 10,
            'inbound_stock' => 10,
            'in_transit_stock' => 10,
        ];
    }
}
