<?php

namespace Database\Factories;

use App\Models\InventoryAdjustment;
use App\Models\InventoryMovement;
use App\Models\Product;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Factories\Factory;

class InventoryAdjustmentFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'adjustment_date' => $this->faker->date(),
            'product_id' => Product::factory(),
            'quantity' => $this->faker->numberBetween(1, 5),
            'warehouse_id' => Warehouse::factory(),
        ];
    }

    // Commenting out because I want explicit control.  The following is only really used by the dummy data seeder
//    public function configure(): self
//    {
//        return $this->afterCreating(function (InventoryAdjustment $adjustment) {
//            // Create FIFO layer and inventory movement, linked to one another, if adjustment is positive
//            if ($adjustment->quantity > 0) {
//                InventoryMovement::factory()->create([
//                    'product_id' => $adjustment->product_id,
//                    'type' => InventoryMovement::TYPE_ADJUSTMENT,
//                    'inventory_status' => InventoryMovement::INVENTORY_STATUS_ACTIVE,
//                    'warehouse_id' => $adjustment->warehouse_id,
//                    'quantity' => $adjustment->quantity,
//                    'link_id' => $adjustment->id,
//                    'link_type' => InventoryAdjustment::class,
//                ]);
//            }
//        });
//    }
}
