<?php

namespace Database\Factories;

use App\Models\Integration;
use Illuminate\Database\Eloquent\Factories\Factory;

class IntegrationInstanceFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'integration_id' => Integration::factory(),
            'name' => $this->faker->sentence(3),
            'connection_settings' => [],
            'integration_settings' => [
                'inventory' => [
                    'locations' => [
                        [
                            'id' => 1,
                            'name' => '500 Westover Dr',
                            'masterOfStock' => 'sku.io',
                            'selectedWarehouses' => [1],
                            'maxRuleType' => 'None',
                            'maxRuleTypeValue' => null,
                            'minRuleType' => 'None',
                            'minRuleTypeValue' => null,
                            'substractBufferStock' => '0',
                            'fulfillmentLatency' => '1',
                        ],
                    ]
                ],
            ],
        ];
    }
}
