<?php

namespace Database\Factories;

use App\Enums\FinancialLineClassificationEnum;
use App\Enums\FinancialLineProrationStrategyEnum;
use App\Models\FinancialLineType;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @mixin FinancialLineType
 */
class FinancialLineTypeFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => $this->faker->word(),
            'classification' => $this->faker->randomElement(FinancialLineClassificationEnum::cases()),
            'allocate_to_products' => $this->faker->boolean(),
            'proration_strategy' => $this->faker->randomElement(FinancialLineProrationStrategyEnum::cases()),
        ];
    }
}
