<?php

namespace Database\Factories;

use App\Models\FinancialAlert;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class FinancialAlertFactory extends Factory
{
    protected $model = FinancialAlert::class;

    public function definition(): array
    {
        return [
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
            'alert_type' => $this->faker->word(),
            'note' => $this->faker->word(),
            'archived_at' => Carbon::now(),
        ];
    }
}
