<?php

namespace Database\Factories;

use App\Models\FifoLayer;
use App\Models\InventoryAdjustment;
use App\Models\Product;
use App\Models\StockTakeItem;
use Illuminate\Database\Eloquent\Factories\Factory;

class FifoLayerFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        /*
         * Note link_type is required so can't create FifoLayerFactory directly.  Must set
         * link_id and link_type through parent relationship
         */
        return [
            'fifo_layer_date' => $this->faker->dateTimeThisMonth(),
            'product_id' => Product::factory(),
            'original_quantity' => $this->faker->numberBetween(20, 100),
            'fulfilled_quantity' => 0,
            'link_type' => StockTakeItem::class,
            'link_id' => StockTakeItem::factory(),
        ];
    }
}
