<?php

namespace Database\Factories;

use App\Models\Address;
use Illuminate\Database\Eloquent\Factories\Factory;

class CustomerFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        $address = Address::factory()->create();

        return [
            'name' => $this->faker->name(),
            'email' => $this->faker->email,
            'default_shipping_address_id' => $address->id,
            'default_billing_address_id' => $address->id,
        ];
    }
}
