<?php

namespace Database\Factories;

use App\Models\BackorderQueue;
use App\Models\Supplier;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<BackorderQueue>
 */
class BackorderQueueFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'backorder_date' => $this->faker->dateTimeBetween('-1 year', 'now')->format('Y-m-d H:i:s'),
            'supplier_id' => Supplier::factory()->withWarehouse(),
            'priority' => 1,
            'backordered_quantity' => $this->faker->numberBetween(1, 10),
            'released_quantity' => 0,
        ];
    }
}
