<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class AddressFactory extends Factory
{
    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'company' => $this->faker->company(),
            'name' => $this->faker->name(),
            'phone' => $this->faker->phoneNumber(),
            'address1' => $this->faker->streetAddress(),
            'address2' => $this->faker->secondaryAddress(),
            'city' => $this->faker->city(),
            'province' => $this->faker->state(),
            'province_code' => substr(strtoupper($this->faker->word()), 0, 2),
            'zip' => $this->faker->postcode(),
            'country' => $this->faker->country(),
            'country_code' => 'US', //$this->faker->countryCode(),
            'email' => $this->faker->unique()->safeEmail(),
        ];
    }
}
