<?php

return [
    /* Legacy Trading API */
    'trading' => [
        'domain' => (env('EBAY_ENVIRONMENT', 'sandbox') === 'sandbox'
            ? 'https://api.sandbox.ebay.com/ws/api.dll'
            : 'https://api.ebay.com/ws/api.dll'
        ),

        'compatibility_level' => '967',
    ],

    /* REST APIs */
    'api' => [
        'domain' => (env('EBAY_ENVIRONMENT', 'sandbox') === 'sandbox'
            ? 'https://api.sandbox.ebay.com'
            : 'https://api.ebay.com'
        ),

        'inventory' => [
            'endpoints' => [
                'inventory' => '/sell/inventory/v1/inventory_item',
                'location' => '/sell/inventory/v1/location',
                'availability' => '/sell/inventory/v1/availability',
                'offer' => '/sell/inventory/v1/offer',
                'pricing' => '/sell/inventory/v1/pricing',
                'variation' => '/sell/inventory/v1/variation',
            ],
        ],

        'fulfillment' => [
            'endpoints' => [
                'order' => '/sell/fulfillment/v1/order',
                'shipment' => '/sell/fulfillment/v1/shipment',
            ],
        ],
    ],

    /*
     * Routes to authorize the SKU.io application with an eBay user account. Think of these as
     * a traditional "registration" endpoint, which establishes a user to an app.
     */
    'auth' => [
        // Often referred to as the "App ID" or the "Client ID"
        //'app_id'                     => env('EBAY_APP_ID', 'SiberVen-skuio-SBX-e75719fb7-8d8bf251'), #sandbox
        'app_id' => env('EBAY_APP_ID', 'SiberVen-skuio-PRD-d69009c8a-b3362c49'),

        // The individual developer user on Ebay's portal
        'dev_id' => env('EBAY_DEV_ID', '7a188eb1-b392-4fff-acf6-1183084e77b8'),

        // Effectively a "secret key" for the app
        //'cert_id'                    => env('EBAY_CERT_ID', 'SBX-75719fb7b138-2e8b-43bc-84b9-bef0'), #sandbox
        'cert_id' => env('EBAY_CERT_ID', 'PRD-69009c8a74fc-4bf6-4862-94a1-1d1b'),

        // Redirect URI RuName (see: https://developer.ebay.com/api-docs/static/oauth-redirect-uri.html)
        //'redirect_uri'               => env('EBAY_REDIRECT_URI', 'Siber_Ventures_-SiberVen-skuio--xwxvdhh'),
        'redirect_uri' => env('EBAY_REDIRECT_URI', 'Siber_Ventures_-SiberVen-skuio--kmkmohmxs'),

        // The base URL for all eBay authorization calls. This gets appended to with specific params.
        'user_authorization_url' => (env('EBAY_ENVIRONMENT', 'sandbox') === 'sandbox'
            ? 'https://auth.sandbox.ebay.com/oauth2/authorize'
            : 'https://auth.ebay.com/oauth2/authorize'
        ),

        /*
     * List of scopes that our application can request. These should be trimmed down as we determine
     * more precisely which resources we are interacting with on eBay's side.
     */
        'scopes' => [
            'https://api.ebay.com/oauth/api_scope',
            'https://api.ebay.com/oauth/api_scope/sell.marketing.readonly',
            'https://api.ebay.com/oauth/api_scope/sell.marketing',
            'https://api.ebay.com/oauth/api_scope/sell.inventory.readonly',
            'https://api.ebay.com/oauth/api_scope/sell.inventory',
            'https://api.ebay.com/oauth/api_scope/sell.account.readonly',
            'https://api.ebay.com/oauth/api_scope/sell.account',
            'https://api.ebay.com/oauth/api_scope/sell.fulfillment.readonly',
            'https://api.ebay.com/oauth/api_scope/sell.fulfillment',
            'https://api.ebay.com/oauth/api_scope/sell.analytics.readonly',
            'https://api.ebay.com/oauth/api_scope/sell.finances',
            'https://api.ebay.com/oauth/api_scope/sell.payment.dispute',
            'https://api.ebay.com/oauth/api_scope/commerce.identity.readonly',
            'https://api.ebay.com/oauth/api_scope/commerce.notification.subscription',
            'https://api.ebay.com/oauth/api_scope/commerce.notification.subscription.readonly',
        ],

        // The callback URL with a "code" parameter that we can use to request an access token
        'auth_accepted_callback_url' => env('APP_URL').'/ebay/callback',

        // If the user does not grant access, this is the url they go to
        'auth_declined_callback_url' => env('APP_URL').'/ebay/oauth-failed',
    ],

    /*
     * Routes to request OAuth tokens. Think of these as "logging in" to an app.
     * These tokens are minted by eBay and are used to make API calls on behalf of the user.
     */
    'tokens' => [
        'token_url' => (env('EBAY_ENVIRONMENT', 'sandbox') === 'sandbox'
            ? 'https://api.sandbox.ebay.com/identity/v1/oauth2/token'
            : 'https://api.ebay.com/identity/v1/oauth2/token'
        ),
    ],

    /*
     * Ebay requires us to subscribe to marketplace account closure/deletion events in order
     * to be able to use their production system.
     */
    'marketplace_account_deletion' => [
        /*
         * This token should be retrievable from our app and placed into the
         * Marketplace Account Deletion screen in the developer portal.
         *
         * There is no specific "recipe" to create this, but it should be a unique string that
         * is not easily guessable. It should also be unique to the environment.
         *
         * Per ebay docs:
         * In the Verification token field, provide a 32 to 80-character verification token.
         * Allowed characters include alphanumeric characters, underscore (_),  and hyphen (-).
         * No other characters are allowed. This Verification token value and the Notification Endpoint
         * URL will be used as a part of a multiple-step process that eBay will use to verify that the
         *  developer owns/has access to the provided Notification Endpoint URL, and that the developer
         * will be receiving and processing all of the marketplace account deletion/closure notifications,
         * and not just selecting a URL that will only pass back a success status code when a notification
         * is sent. See the previous section for information on preparing your endpoint, and the validation
         * process.
         *
         * @see https://developer.ebay.com/marketplace-account-deletion #7
         */
        'verification_token' => base64_encode(sprintf('%s-%s', env('APP_ENV'), env('APP_KEY'))),

        /*
         * This is the URL that eBay will call to verify the application.
         * This should be placed into the Marketplace Account Deletion screen in
         * the developer portal.
         */
        'callback_url' => env(
            'EBAY_CALLBACK_URL',
            'https://www.sku.io/ebay/compliance/marketplace-account-deletion'
        ),
    ],
];
