<?php

$fields = [
    'id' => 'integer',
    'woo_commerce_id' => 'integer',
    'number' => 'string',
    'sku_sales_order_id' => 'integer',
    'status' => 'string',
    'total' => 'string',
    'total_tax' => 'string',
    'currency' => 'string',
    'date_created_gmt' => 'date/time',
    'date_modified_gmt' => 'date/time',
    'created_at' => 'date/time',
    'updated_at' => 'date/time',
];

$visible = $fields;
$filterable = $fields;
$sortable = $filterable;

$specialLabels = [
    'woo_commerce_id' => 'ID',
    'sku_sales_order_id' => 'SKU Order',
    'date_created_gmt' => 'Order Created',
    'date_modified_gmt' => 'Order Updated',
];

$labels = [];
foreach (array_keys($fields) as $field) {
    if (array_key_exists($field, $specialLabels)) {
        $labels[$field] = $specialLabels[$field];
    } else {
        $labels[$field] = ucwords(str_replace('_', ' ', $field));
    }
}

$order = 1;
$columns = [];
foreach ($fields as $field => $type) {
    $columns[] = [
        'data_name' => $field,
        'column_label' => $labels[$field],
        'default_order' => $order++,
        'group' => 'Basic Info',
        'group_data' => 'basic_info',
        'default_visible' => $visible[$field] ?? 0,
        'sortable' => $sortable[$field] ?? 0,
        'editable' => 0,
        'filterable' => $filterable[$field] ?? 0,
        'dropdown' => 0,
        'type' => $type,
    ];
}

return [
    'rows_deletable' => 0,
    'frozen_columns' => ['id'],
    'default_sort' => [['field' => 'created_at', 'sort' => 'DESC']],
    'columns' => $columns,
];
