<?php

return [
    'rows_deletable' => 1,
    'frozen_columns' => ['id'],
    'default_sort' => [['field' => 'created_at', 'sort' => 'DESC']],
    'columns' => [
        //-----------------------------------------------------
        // Basic Info
        //-----------------------------------------------------

        [
            'data_name' => 'warehouse_transfer_number',
            'column_label' => 'Transfer #',
            'default_order' => 0,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'id',
            'column_label' => 'ID',
            'default_order' => 1,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'transfer_date',
            'column_label' => 'Date',
            'default_order' => 2,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],
        [
            'data_name' => 'statuses',
            'column_label' => 'Statuses',
            'default_order' => 3,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'statuses',
        ],
        [
            'data_name' => 'status',
            'column_label' => 'Status',
            'default_order' => 4,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'shipment_status',
            'column_label' => 'Shipment Status',
            'default_order' => 5,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'receipt_status',
            'column_label' => 'Receipt Status',
            'default_order' => 6,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'from_warehouse',
            'column_label' => 'From',
            'default_order' => 7,
            'group' => 'Logistics',
            'group_data' => 'logistics',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'warehouse',
        ],
        [
            'data_name' => 'to_warehouse',
            'column_label' => 'To',
            'default_order' => 8,
            'group' => 'Logistics',
            'group_data' => 'logistics',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'warehouse',
        ],
        [
            'data_name' => 'items',
            'column_label' => 'Items',
            'default_order' => 9,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'only_grouped' => 1,
            'type' => 'items',
        ],
        [
            'data_name' => 'item_quantity',
            'column_label' => 'Item Quantity',
            'default_order' => 10,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'item_sku',
            'column_label' => 'Item SKU',
            'default_order' => 11,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_barcode',
            'column_label' => 'Item Barcode',
            'default_order' => 12,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_name',
            'column_label' => 'Item Name',
            'default_order' => 13,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_quantity_received',
            'column_label' => 'Item Quantity Received',
            'default_order' => 14,
            'group' => 'Items',
            'group_data' => 'items',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'created_at',
            'column_label' => 'Created At',
            'default_order' => 15,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'updated_at',
            'column_label' => 'Updated At',
            'default_order' => 16,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'archived_at',
            'column_label' => 'Archived At',
            'default_order' => 17,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'asn_last_sent_at',
            'column_label' => 'ASN Last Sent At',
            'default_order' => 18,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date',
        ],
        [
            'data_name' => 'asn_sent',
            'column_label' => 'ASN sent?',
            'default_order' => 19,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'boolean',
            'is_scope' => true
        ],
    ],
];
