<?php

return [
    'rows_deletable' => 1,
    'frozen_columns' => ['basic_info', 'fulfillment_number'],
    'default_sort' => [['field' => 'created_at', 'sort' => 'DESC']],
    'default_density' => 'expanded',
    'columns' => [
        //-----------------------------------------------------
        // Basic Info
        //-----------------------------------------------------

        [
            'data_name' => 'basic_info',
            'column_label' => 'Basic Info',
            'default_order' => 0,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'basic_info',
        ],
        [
            'data_name' => 'fulfillment_number',
            'column_label' => 'Fulfillment #',
            'default_order' => 1,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'fulfillment_sequence',
            'column_label' => 'Fulfillment Sequence',
            'default_order' => 2,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'fulfillment_type',
            'column_label' => 'Fulfillment Type',
            'default_order' => 2,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'warehouse',
            'column_label' => 'Warehouse',
            'default_order' => 2,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'warehouse',
        ],
        [
            'data_name' => 'requested_shipping_method',
            'column_label' => 'Requested Shipping Method',
            'default_order' => 3,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'fulfillment_shipping_method',
            'column_label' => 'Fulfillment Shipping Method',
            'default_order' => 4,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'tracking_number',
            'column_label' => 'Tracking #',
            'default_order' => 4,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'fulfilled_at',
            'column_label' => 'Fulfilled Date',
            'default_order' => 4,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'packing_slip_printed_at',
            'column_label' => 'Packing Slip Printed At',
            'default_order' => 5,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'cost',
            'column_label' => 'Cost',
            'default_order' => 6,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'created_at',
            'column_label' => 'Created At',
            'default_order' => 7,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'updated_at',
            'column_label' => 'Updated At',
            'default_order' => 8,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'archived_at',
            'column_label' => 'Archived At',
            'default_order' => 9,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'id',
            'column_label' => 'Internal ID',
            'default_order' => 10,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],

        //-----------------------------------------------------
        // Sales Order
        //-----------------------------------------------------

        [
            'data_name' => 'sales_order_info',
            'column_label' => 'Sales Order',
            'default_order' => 0,
            'group' => 'Sales Order',
            'group_data' => 'sales_order_info',
            'default_visible' => 11,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'sales_order_info',
        ],
        [
            'data_name' => 'customer_reference',
            'column_label' => 'Sales Order #',
            'default_order' => 12,
            'group' => 'Sales Order',
            'group_data' => 'sales_order_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'store',
            'column_label' => 'Store',
            'default_order' => 13,
            'group' => 'Sales Order',
            'group_data' => 'sales_order_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'sales_channel_type_name',
            'column_label' => 'Sales Channel Type',
            'default_order' => 14,
            'group' => 'Sales Order',
            'group_data' => 'sales_order_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'sales_order_shipping_method',
            'column_label' => 'Shipping Method',
            'default_order' => 15,
            'group' => 'Sales Order',
            'group_data' => 'sales_order_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'sales_order_tags',
            'column_label' => 'Tags',
            'default_order' => 36,
            'group' => 'Sales Order',
            'group_data' => 'sales_order_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Customer
        //-----------------------------------------------------

        [
            'data_name' => 'customer_info',
            'column_label' => 'Customer',
            'default_order' => 16,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'customer_info',
        ],
        [
            'data_name' => 'customer_name',
            'column_label' => 'Customer Name',
            'default_order' => 17,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'customer_name',
        ],
        [
            'data_name' => 'customer_email',
            'column_label' => 'Customer Email',
            'default_order' => 18,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_company',
            'column_label' => 'Customer Company',
            'default_order' => 19,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_phone',
            'column_label' => 'Customer Phone',
            'default_order' => 20,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_address',
            'column_label' => 'Customer Address',
            'default_order' => 21,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_city',
            'column_label' => 'Customer City',
            'default_order' => 22,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_province',
            'column_label' => 'Customer State/Province',
            'default_order' => 23,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_province_code',
            'column_label' => 'Customer State/Province Code',
            'default_order' => 24,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_zip',
            'column_label' => 'Customer Zip',
            'default_order' => 25,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_country',
            'column_label' => 'Customer Country',
            'default_order' => 26,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_country_code',
            'column_label' => 'Customer Country Code',
            'default_order' => 27,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Items
        //-----------------------------------------------------

        [
            'data_name' => 'item_info',
            'column_label' => 'Items',
            'default_order' => 28,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'only_grouped' => 1,
            'type' => 'item_info',
        ],
        [
            'data_name' => 'item_quantity',
            'column_label' => 'Item Quantity',
            'default_order' => 29,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'item_sku',
            'column_label' => 'Item SKU',
            'default_order' => 30,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_price',
            'column_label' => 'Item Price',
            'default_order' => 31,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'item_name',
            'column_label' => 'Item Name',
            'default_order' => 32,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_nominal_code',
            'column_label' => 'Item Nominal Code',
            'default_order' => 33,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Statuses
        //-----------------------------------------------------

        [
            'data_name' => 'statuses',
            'column_label' => 'Statuses',
            'default_order' => 34,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'statuses',
        ],
        [
            'data_name' => 'status',
            'column_label' => 'Status',
            'default_order' => 35,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
    ],
];
