<?php

return [
    'rows_deletable' => 0,
    'frozen_columns' => ['basic_info', 'sales_order_number'],
    'default_sort' => [['field' => 'created_at', 'sort' => 'DESC']],
    'default_density' => 'expanded',
    'columns' => [
        //-----------------------------------------------------
        // Basic Info
        //-----------------------------------------------------

        [
            'data_name' => 'basic_info',
            'column_label' => 'Basic Info',
            'default_order' => 0,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'basic_order_info',
        ],
        [
            'data_name' => 'sales_order_number',
            'column_label' => 'Order Reference #',
            'default_order' => 1,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'id',
            'column_label' => 'Internal ID',
            'default_order' => 2,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'sales_channel_name',
            'column_label' => 'Sales Channel',
            'default_order' => 3,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'integration',
            'column_label' => 'Integration',
            'default_order' => 4,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'integration_image',
            'column_label' => 'Integration Image',
            'default_order' => 4,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'store',
            'column_label' => 'Store',
            'default_order' => 5,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'store',
        ],
        [
            'data_name' => 'order_date',
            'column_label' => 'Order Date',
            'default_order' => 6,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'payment_date',
            'column_label' => 'Payment Date',
            'default_order' => 7,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'is_tax_included',
            'column_label' => 'Tax Included?',
            'default_order' => 7,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],
        [
            'data_name' => 'is_replacement_order',
            'column_label' => 'Is Replacement Order?',
            'default_order' => 7,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],
        [
            'data_name' => 'canceled_at',
            'column_label' => 'Canceled At',
            'default_order' => 8,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'created_at',
            'column_label' => 'Created At',
            'default_order' => 9,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'updated_at',
            'column_label' => 'Updated At',
            'default_order' => 10,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'archived_at',
            'column_label' => 'Archived At',
            'default_order' => 11,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'warehouses',
            'column_label' => 'Warehouses',
            'default_order' => 12,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'warehouses',
        ],
        [
            'data_name' => 'covered_by_po',
            'column_label' => 'Covered by PO #',
            'default_order' => 13,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Fulfillment
        //-----------------------------------------------------
        [
            'data_name' => 'fulfillment_info',
            'column_label' => 'Fulfillment',
            'default_order' => 14,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'fulfillment_info',
        ],
        [
            'data_name' => 'ship_by_date',
            'column_label' => 'Ship By Date',
            'default_order' => 15,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'deliver_by_date',
            'column_label' => 'Delivery By Date',
            'default_order' => 16,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'shipping_method',
            'column_label' => 'Shipping Method',
            'default_order' => 17,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'requested_shipping_method',
            'column_label' => 'Requested Shipping Method',
            'default_order' => 18,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'backordered',
            'column_label' => 'Backorder',
            'default_order' => 19,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'boolean',
        ],
        [
            'data_name' => 'fulfilled_at',
            'column_label' => 'Fully Fulfilled Date',
            'default_order' => 19,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],

        //-----------------------------------------------------
        // Customer
        //-----------------------------------------------------

        [
            'data_name' => 'customer_info',
            'column_label' => 'Customer',
            'default_order' => 20,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'customer_info',
        ],
        [
            'data_name' => 'customer_name',
            'column_label' => 'Customer Name',
            'default_order' => 21,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'customer_name',
        ],
        [
            'data_name' => 'customer_email',
            'column_label' => 'Customer Email',
            'default_order' => 22,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_company',
            'column_label' => 'Customer Company',
            'default_order' => 23,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_phone',
            'column_label' => 'Customer Phone',
            'default_order' => 24,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_address',
            'column_label' => 'Customer Address',
            'default_order' => 25,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_city',
            'column_label' => 'Customer City',
            'default_order' => 26,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_province',
            'column_label' => 'Customer State/Province',
            'default_order' => 27,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_province_code',
            'column_label' => 'Customer State/Province Code',
            'default_order' => 28,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_zip',
            'column_label' => 'Customer Zip',
            'default_order' => 29,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_country',
            'column_label' => 'Customer Country',
            'default_order' => 30,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_country_code',
            'column_label' => 'Customer Country Code',
            'default_order' => 31,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'sales_order_shipping_address',
            'column_label' => 'Sales Order Shipping Address',
            'default_order' => 31,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'sales_order_billing_address',
            'column_label' => 'Sales Order Billing Address',
            'default_order' => 31,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'shipping_city',
            'column_label' => 'Shipping City',
            'default_order' => 31,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'shipping_state_province',
            'column_label' => 'Shipping State Province',
            'default_order' => 31,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Items
        //-----------------------------------------------------

        [
            'data_name' => 'item_info',
            'column_label' => 'Items',
            'default_order' => 32,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'only_grouped' => 1,
            'type' => 'item_info',
        ],
        [
            'data_name' => 'item_quantity',
            'column_label' => 'Item Quantity',
            'default_order' => 33,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'item_sku',
            'column_label' => 'Item SKU',
            'default_order' => 34,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_bundle_sku',
            'column_label' => 'Item Bundle SKU',
            'default_order' => 35,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_price',
            'column_label' => 'Item Price',
            'default_order' => 35,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'item_name',
            'column_label' => 'Item Name',
            'default_order' => 36,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_brand',
            'column_label' => 'Item Brand',
            'default_order' => 34,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_nominal_code',
            'column_label' => 'Item Nominal Code',
            'default_order' => 37,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_tax_rate',
            'column_label' => 'Item Tax Rate',
            'default_order' => 37,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'is_product',
            'column_label' => 'Is Product?',
            'default_order' => 38,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],

        [
            'data_name' => 'item_has_backorder',
            'column_label' => 'Item Has Backorder',
            'default_order' => 38,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],

        //-----------------------------------------------------
        // Statuses
        //-----------------------------------------------------

        [
            'data_name' => 'statuses',
            'column_label' => 'Statuses',
            'default_order' => 39,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'statuses',
        ],
        [
            'data_name' => 'order_status',
            'column_label' => 'Order Status',
            'default_order' => 40,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'payment_status',
            'column_label' => 'Payment Status',
            'default_order' => 41,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'fulfillment_status',
            'column_label' => 'Fulfillment Status',
            'default_order' => 42,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Totals
        //-----------------------------------------------------

        [
            'data_name' => 'totals',
            'column_label' => 'Totals',
            'default_order' => 43,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'totals',
        ],
        [
            'data_name' => 'total_revenue_allocated',
            'column_label' => 'Total Revenue Allocated',
            'default_order' => 44,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'financial_lines_revenue_total',
            'column_label' => 'Total Financial Lines Revenue',
            'default_order' => 44,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'tax_revenue',
            'column_label' => 'Tax Revenue',
            'default_order' => 45,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'discount_total',
            'column_label' => 'Discount',
            'default_order' => 46,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'product_total',
            'column_label' => 'Product Subtotal',
            'default_order' => 47,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'total',
            'column_label' => 'Total',
            'default_order' => 48,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'currency_code',
            'column_label' => 'Currency',
            'default_order' => 50,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'total_revenue',
            'column_label' => 'Total Revenue',
            'default_order' => 51,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],

        //-----------------------------------------------------
        // Other
        //-----------------------------------------------------

        [
            'data_name' => 'tags',
            'column_label' => 'Tags',
            'default_order' => 51,
            'group' => 'Other',
            'group_data' => 'other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'tags',
        ],
        [
            'data_name' => 'fulfillment_channel',
            'column_label' => 'Amazon Fulfillment',
            'default_order' => 52,
            'group' => 'Other',
            'group_data' => 'other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'fulfillment_channel',
        ],
        [
            'data_name' => 'mapping_needed',
            'column_label' => 'Product Mapping Needed?',
            'default_order' => 53,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'boolean',
        ],
        [
            'data_name' => 'fulfillable',
            'column_label' => 'Can Fulfill?',
            'default_order' => 54,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'sourcing',
            'column_label' => 'Sourcing',
            'default_order' => 55,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'packing_slip_printed_at',
            'column_label' => 'Packing Slip Printed At',
            'default_order' => 56,
            'group' => 'Fulfillment',
            'group_data' => 'fulfillment_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
    ],
];
