<?php

return [
    'rows_deletable' => 1,
    'frozen_columns' => ['basic_info', 'customer_reference'],
    'default_sort' => [['field' => 'created_at', 'sort' => 'DESC']],
    'columns' => [
        //-----------------------------------------------------
        // Basic Info
        //-----------------------------------------------------

        [
            'data_name' => 'basic_info',
            'column_label' => 'Basic Info',
            'default_order' => 0,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'basic_order_info',
        ],
        [
            'data_name' => 'sales_credit_number',
            'column_label' => 'Credit Reference #',
            'default_order' => 1,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'id',
            'column_label' => 'Internal ID',
            'default_order' => 2,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'store',
            'column_label' => 'Store',
            'default_order' => 3,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'store',
        ],
        [
            'data_name' => 'credit_date',
            'column_label' => 'Credit Date',
            'default_order' => 4,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        //    [
        //      'data_name'       => 'payment_date',
        //      'column_label'    => 'Payment Date',
        //      'default_order'   => 5,
        //      'group'           => 'Basic Info',
        //      'group_data'      => 'basic_info',
        //      'default_visible' => 0,
        //      'sortable'        => 1,
        //      'editable'        => 0,
        //      'filterable'      => 1,
        //      'dropdown'        => 0,
        //      'type'            => 'date/time',
        //    ],
        [
            'data_name' => 'created_at',
            'column_label' => 'Created At',
            'default_order' => 6,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'updated_at',
            'column_label' => 'Updated At',
            'default_order' => 7,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'archived_at',
            'column_label' => 'Archived At',
            'default_order' => 8,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],

        //-----------------------------------------------------
        // Returns
        //-----------------------------------------------------

        [
            'data_name' => 'returns_info',
            'column_label' => 'Returns',
            'default_order' => 9,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'only_grouped' => 1,
            'type' => 'returns_info',
        ],
        [
            'data_name' => 'to_warehouse',
            'column_label' => 'Warehouse',
            'default_order' => 10,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'warehouse',
        ],
        [
            'data_name' => 'returns_receipt_date',
            'column_label' => 'Receipt Date',
            'default_order' => 11,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'returns_receipt_quantity',
            'column_label' => 'Receipt Quantity',
            'default_order' => 12,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'returns_receipt_items_sku',
            'column_label' => 'Receipt Item SKU',
            'default_order' => 13,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'returns_receipt_items_quantity',
            'column_label' => 'Receipt Item Quantity',
            'default_order' => 14,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'returns_receipt_items_reason',
            'column_label' => 'Receipt Item Reason',
            'default_order' => 15,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'returns_receipt_items_reason_notes',
            'column_label' => 'Receipt Item Reason Notes',
            'default_order' => 16,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'returns_receipt_items_action',
            'column_label' => 'Receipt Item Action',
            'default_order' => 17,
            'group' => 'Returns',
            'group_data' => 'returns_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Customer
        //-----------------------------------------------------

        [
            'data_name' => 'customer_info',
            'column_label' => 'Customer',
            'default_order' => 18,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'customer_info',
        ],
        [
            'data_name' => 'customer_name',
            'column_label' => 'Customer Name',
            'default_order' => 19,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'customer_name',
        ],
        [
            'data_name' => 'customer_email',
            'column_label' => 'Customer Email',
            'default_order' => 20,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_company',
            'column_label' => 'Customer Company',
            'default_order' => 21,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_phone',
            'column_label' => 'Customer Phone',
            'default_order' => 22,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_address',
            'column_label' => 'Customer Address',
            'default_order' => 23,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_city',
            'column_label' => 'Customer City',
            'default_order' => 24,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_province',
            'column_label' => 'Customer State/Province',
            'default_order' => 25,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_province_code',
            'column_label' => 'Customer State/Province Code',
            'default_order' => 26,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_zip',
            'column_label' => 'Customer Zip',
            'default_order' => 27,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_country',
            'column_label' => 'Customer Country',
            'default_order' => 28,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'customer_country_code',
            'column_label' => 'Customer Country Code',
            'default_order' => 29,
            'group' => 'Customer',
            'group_data' => 'customer_info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Items
        //-----------------------------------------------------

        [
            'data_name' => 'item_info',
            'column_label' => 'Items',
            'default_order' => 30,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'only_grouped' => 1,
            'type' => 'item_info',
        ],
        [
            'data_name' => 'item_quantity',
            'column_label' => 'Item Quantity',
            'default_order' => 31,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'item_sku',
            'column_label' => 'Item SKU',
            'default_order' => 32,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'item_sku',
        ],
        [
            'data_name' => 'item_price',
            'column_label' => 'Item Price',
            'default_order' => 33,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'item_name',
            'column_label' => 'Item Name',
            'default_order' => 34,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'item_nominal_code',
            'column_label' => 'Item Nominal Code',
            'default_order' => 35,
            'group' => 'Items',
            'group_data' => 'item_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Statuses
        //-----------------------------------------------------

        [
            'data_name' => 'statuses',
            'column_label' => 'Statuses',
            'default_order' => 36,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'statuses',
        ],
        [
            'data_name' => 'credit_status',
            'column_label' => 'Credit Status',
            'default_order' => 37,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        //    [
        //      'data_name'       => 'payment_status',
        //      'column_label'    => 'Payment Status',
        //      'default_order'   => 38,
        //      'group'           => 'Statuses',
        //      'group_data'      => 'statuses',
        //      'default_visible' => 1,
        //      'sortable'        => 1,
        //      'editable'        => 0,
        //      'filterable'      => 1,
        //      'dropdown'        => 0,
        //      'type'            => 'string',
        //    ],
        [
            'data_name' => 'return_status',
            'column_label' => 'Return Status',
            'default_order' => 39,
            'group' => 'Statuses',
            'group_data' => 'statuses',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Totals
        //-----------------------------------------------------

        [
            'data_name' => 'totals',
            'column_label' => 'Totals',
            'default_order' => 40,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'totals',
        ],
        [
            'data_name' => 'additional_credit',
            'column_label' => 'Additional Credit',
            'default_order' => 41,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'tax_credit',
            'column_label' => 'Tax Credit',
            'default_order' => 42,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'discount',
            'column_label' => 'Discount',
            'default_order' => 43,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'product_total',
            'column_label' => 'Subtotal',
            'default_order' => 44,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'total',
            'column_label' => 'Total',
            'default_order' => 45,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'currency_code',
            'column_label' => 'Currency',
            'default_order' => 46,
            'group' => 'Totals',
            'group_data' => 'totals',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Other
        //-----------------------------------------------------

        [
            'data_name' => 'tags',
            'column_label' => 'Tags',
            'default_order' => 46,
            'group' => 'Other',
            'group_data' => 'other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'tags',
        ],
        [
            'data_name' => 'has_products',
            'column_label' => 'Has Returns',
            'default_order' => 47,
            'group' => 'Other',
            'group_data' => 'other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],
    ],
];
