<?php

return [
    'rows_deletable' => 1,
    'frozen_columns' => ['sku'],
    'default_sort' => [['field' => 'updated_at', 'sort' => 'DESC']],
    'default_density' => 'compact',
    'columns' => [
        //-----------------------------------------------------
        // Basic Info
        //-----------------------------------------------------

        [
            'data_name' => 'sku',
            'column_label' => 'SKU',
            'default_order' => 0,
            'group' => 'Basic Info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'id',
            'column_label' => 'ID',
            'default_order' => 1,
            'group' => 'Basic Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'image',
            'column_label' => 'Image',
            'default_order' => 2,
            'group' => 'Basic Info',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'image',
        ],
        [
            'data_name' => 'image_url',
            'column_label' => 'Image URL',
            'default_order' => 3,
            'group' => 'Basic Info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'image_resolvable',
            'column_label' => 'Image Resolvable',
            'default_order' => 3,
            'group' => 'Basic Info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],
        [
            'data_name' => 'other_images',
            'column_label' => 'Other Images',
            'default_order' => 3,
            'group' => 'Basic Info',
            'default_visible' => 0,
            'only_grouped' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'other_images',
        ],
        [
            'data_name' => 'name',
            'column_label' => 'Name',
            'default_order' => 4,
            'group' => 'Basic Info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'brand',
            'column_label' => 'Brand',
            'default_order' => 5,
            'group' => 'Basic Info',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 1,
            'type' => 'brand',
        ],
        [
            'data_name' => 'barcode',
            'column_label' => 'Barcode',
            'default_order' => 6,
            'group' => 'Basic Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'mpn',
            'column_label' => 'MPN',
            'default_order' => 6,
            'group' => 'Basic Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'unit_cost',
            'column_label' => 'Unit Cost',
            'default_order' => 7,
            'group' => 'Basic Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'tags',
            'column_label' => 'Tags',
            'default_order' => 7,
            'group' => 'Basic Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'tags',
        ],

        //-----------------------------------------------------
        // Other
        //-----------------------------------------------------

        [
            'data_name' => 'type',
            'column_label' => 'Type',
            'default_order' => 8,
            'group' => 'Other',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'has_fba',
            'column_label' => 'Has FBA',
            'default_order' => 9,
            'group' => 'Other',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],
        [
            'data_name' => 'parent_product',
            'column_label' => 'Parent Product',
            'default_order' => 10,
            'group' => 'Other',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'product_parent',
        ],
        [
            'data_name' => 'variations',
            'column_label' => 'Variations',
            'default_order' => 11,
            'group' => 'Other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'variations',
        ],
        //-----------------------------------------------------
        // Pricing & Cost
        //-----------------------------------------------------

        [
            'data_name' => 'price',
            'column_label' => 'Price Value',
            'default_order' => 11,
            'group' => 'Pricing & Cost',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'average_cost',
            'column_label' => 'Avg Cost',
            'default_order' => 17,
            'group' => 'Pricing & Cost',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'currency',
        ],

        //-----------------------------------------------------
        // Sourcing
        //-----------------------------------------------------

        [
            'data_name' => 'default_supplier',
            'column_label' => 'Supplier',
            'default_order' => 18,
            'group' => 'Sourcing',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 1,
            'type' => 'supplier',
        ],
        [
            'data_name' => 'default_supplier_sku',
            'column_label' => 'Supplier SKU',
            'default_order' => 19,
            'group' => 'Sourcing',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'default_supplier_leadtime',
            'column_label' => 'Leadtime (Days)',
            'default_order' => 20,
            'group' => 'Sourcing',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'default_supplier_moq',
            'column_label' => 'MOQ',
            'default_order' => 21,
            'group' => 'Sourcing',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'supplier_pricing',
            'column_label' => 'Supplier Pricing',
            'default_order' => 25,
            'group' => 'Sourcing',
            'default_visible' => 1,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'supplier_pricing',
        ],
        [
            'data_name' => 'suppliersInventory.discontinued',
            'column_label' => 'Supplier Discontinued',
            'default_order' => 26,
            'group' => 'Sourcing',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],
        [
            'data_name' => 'suppliersInventory.in_stock',
            'column_label' => 'Supplier In Stock',
            'default_order' => 26,
            'group' => 'Sourcing',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'checkbox',
        ],

        //-----------------------------------------------------
        // Shipping Info
        //-----------------------------------------------------

        [
            'data_name' => 'weight',
            'column_label' => 'Shipping Weight Value',
            'default_order' => 28,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'component_skus',
            'column_label' => 'COMPONENT SKUS',
            'default_order' => 12,
            'group' => 'Other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'component_skus',
        ],
        [
            'data_name' => 'component_of_sku',
            'column_label' => 'COMPONENT OF SKU',
            'default_order' => 10,
            'group' => 'Other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'component_of_sku',
        ],
        [
            'data_name' => 'component_of_id',
            'column_label' => 'COMPONENT OF id',
            'default_order' => 11,
            'group' => 'Other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'component_of_id',
        ],
        [
            'data_name' => 'component_ids',
            'column_label' => 'COMPONENT IDS',
            'default_order' => 13,
            'group' => 'Other',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'component_ids',
        ],
        [
            'data_name' => 'weight_unit',
            'column_label' => 'Shipping Weight Unit',
            'default_order' => 29,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 1,
            'type' => 'string',
        ],
        [
            'data_name' => 'weight_info',
            'column_label' => 'Shipping Weight',
            'default_order' => 30,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'weight',
        ],
        [
            'data_name' => 'length',
            'column_label' => 'Shipping Length',
            'default_order' => 31,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'width',
            'column_label' => 'Shipping Width',
            'default_order' => 32,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'height',
            'column_label' => 'Shipping Height',
            'default_order' => 33,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'dimensions_unit',
            'column_label' => 'Shipping Dimensions Unit',
            'default_order' => 34,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 1,
            'type' => 'string',
        ],
        [
            'data_name' => 'dimensions_info',
            'column_label' => 'Shipping Dimensions',
            'default_order' => 35,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'dimensions',
        ],
        [
            'data_name' => 'case_weight',
            'column_label' => 'Case Shipping Weight Value',
            'default_order' => 36,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'case_weight_unit',
            'column_label' => 'Case Shipping Weight Unit',
            'default_order' => 37,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 1,
            'type' => 'string',
        ],
        [
            'data_name' => 'case_weight_info',
            'column_label' => 'Case Shipping Weight',
            'default_order' => 38,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'weight',
        ],
        [
            'data_name' => 'fba_prep_instructions',
            'column_label' => 'FBA Prep Instructions',
            'default_order' => 39,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'case_quantity',
            'column_label' => 'Case Qty',
            'default_order' => 40,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'case_length',
            'column_label' => 'Case Shipping Length',
            'default_order' => 41,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'case_width',
            'column_label' => 'Case Shipping Width',
            'default_order' => 42,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'case_height',
            'column_label' => 'Case Shipping Height',
            'default_order' => 43,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],
        [
            'data_name' => 'case_dimensions_unit',
            'column_label' => 'Case Shipping Dimensions Unit',
            'default_order' => 44,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 1,
            'type' => 'string',
        ],
        [
            'data_name' => 'case_dimensions',
            'column_label' => 'Case Shipping Dimensions',
            'default_order' => 45,
            'group' => 'Shipping Info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'dimensions',
        ],

        //-----------------------------------------------------
        // Taxonomy
        //-----------------------------------------------------

        [
            'data_name' => 'category_main',
            'column_label' => 'Main Category',
            'default_order' => 46,
            'group' => 'Taxonomy',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 1,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'category',
        ],
        [
            'data_name' => 'category_main_path',
            'column_label' => 'Main Category (Path)',
            'default_order' => 47,
            'group' => 'Taxonomy',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'category_path',
        ],
        [
            'data_name' => 'category_others',
            'column_label' => 'Other Categories',
            'default_order' => 48,
            'group' => 'Taxonomy',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'category_others',
        ],
        [
            'data_name' => 'category_others_path',
            'column_label' => 'Other Categories (Path)',
            'default_order' => 49,
            'group' => 'Taxonomy',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'category_path',
        ],

        //-----------------------------------------------------
        // Inventory
        //-----------------------------------------------------

        [
            'data_name' => 'inventory_total',
            'column_label' => 'Stock',
            'default_order' => 50,
            'group' => 'Inventory',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'inventory_available',
            'column_label' => 'Available',
            'default_order' => 51,
            'group' => 'Inventory',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'inventory_reserved',
            'column_label' => 'Reserved',
            'default_order' => 52,
            'group' => 'Inventory',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'inventory_incoming',
            'column_label' => 'Incoming',
            'default_order' => 53,
            'group' => 'Inventory',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'inventory_in_transit',
            'column_label' => 'In Transit',
            'default_order' => 54,
            'group' => 'Inventory',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'inventory',
            'column_label' => 'Inventory',
            'default_order' => 55,
            'group' => 'Inventory',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'inventory_available_warehouses',
            'column_label' => 'Inventory (Available) per Warehouse',
            'default_order' => 55,
            'group' => 'Inventory',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'integer',
        ],
        [
            'data_name' => 'inventory_stock_value',
            'column_label' => 'Stock Value',
            'default_order' => 56,
            'group' => 'Inventory',
            'default_visible' => 1,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'currency',
        ],
        [
            'data_name' => 'daily_average_consumption',
            'column_label' => 'Daily Average Consumption',
            'default_order' => 57,
            'group' => 'Inventory',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'decimal',
        ],

        //-----------------------------------------------------
        // Attributes
        //-----------------------------------------------------

        [
            'data_name' => 'attributes',
            'column_label' => 'Attributes',
            'default_order' => 58,
            'group' => 'Attributes',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'string',
        ],

        //-----------------------------------------------------
        // Timestamps
        //-----------------------------------------------------

        [
            'data_name' => 'archived_at',
            'column_label' => 'Archived At',
            'default_order' => 59,
            'group' => 'Timestamps',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'created_at',
            'column_label' => 'Created At',
            'default_order' => 60,
            'group' => 'Timestamps',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'date_of_return',
            'column_label' => 'Date of Return',
            'default_order' => 61,
            'group' => 'Timestamps',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'date_of_sales_credit',
            'column_label' => 'Date of Sales Credit',
            'default_order' => 61,
            'group' => 'Timestamps',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],
        [
            'data_name' => 'updated_at',
            'column_label' => 'Updated At',
            'default_order' => 61,
            'group' => 'Timestamps',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'date/time',
        ],

        //-----------------------------------------------------
        // Nominal Codes
        //-----------------------------------------------------

        [
            'data_name' => 'sales_nominal_code',
            'column_label' => 'Sales Nominal Code',
            'default_order' => 62,
            'group' => 'Nominal Codes',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'cogs_nominal_code',
            'column_label' => 'COGS Nominal Code',
            'default_order' => 63,
            'group' => 'Nominal Codes',
            'default_visible' => 0,
            'sortable' => 1,
            'editable' => 0,
            'filterable' => 1,
            'dropdown' => 0,
            'type' => 'string',
        ],
        [
            'data_name' => 'suppliers',
            'column_label' => 'Suppliers',
            'default_order' => 2,
            'group' => 'Basic Info',
            'group_data' => 'basic_info',
            'default_visible' => 0,
            'sortable' => 0,
            'editable' => 0,
            'filterable' => 0,
            'dropdown' => 0,
            'type' => 'array',
        ],
    ],
];
