<?php

use App\Models\Product;

return [
    'file_extension' => config('data_feed.extensions'),
    'import_settings' => config('data_feed.import_setting'),
    'field_mappings' => [
        [
            'database_column' => 'sku',
            'required' => true,
            'type' => 'string',
        ],
        [
            'database_column' => 'type',
            'required' => false,
            'type' => 'enum',
            'allowed_values' => Product::TYPES,
        ],
        [
            'database_column' => 'barcode',
            'required' => false,
            'type' => 'string',
        ],
        [
            'database_column' => 'mpn',
            'required' => false,
            'type' => 'string',
        ],
        [
            'database_column' => 'weight',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'weight_unit',
            'required' => false,
            'type' => 'enum',
            'allowed_values' => Product::WEIGHT_UNITS,
        ],
        [
            'database_column' => 'length',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'width',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'height',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'dimension_unit',
            'required' => false,
            'type' => 'enum',
            'allowed_values' => Product::DIMENSION_UNITS,
        ],
        [
            'database_column' => 'fba_prep_instructions',
            'required' => false,
            'type' => 'string',
        ],
        [
            'database_column' => 'case_quantity',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'case_length',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'case_width',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'case_height',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'case_dimension_unit',
            'required' => false,
            'type' => 'string',
        ],
        [
            'database_column' => 'case_weight',
            'required' => false,
            'type' => 'string',
        ],
        [
            'database_column' => 'case_weight_unit',
            'required' => false,
            'type' => 'string',
        ],
        [
            'database_column' => 'average_cost',
            'required' => false,
            'type' => 'double',
        ],
        [
            'database_column' => 'shared_children_attributes',
            'required' => false,
            'type' => 'text',
        ],
        [
            'database_column' => 'price.*.value',
            'required' => false,
            'type' => 'double',
            'relationship' => 'productPricingTiers',
        ],
        [
            'database_column' => 'supplier.*.value',
            'required' => false,
            'type' => 'double',
            'relationship' => 'TBD',
        ],
        [
            'database_column' => 'supplier_name',
            'required' => false,
            'type' => 'string',
            'relationship' => 'suppliers',
        ],
    ],
    'sample_data' => [
        [
            'sku' => 'SKU-1',
            'name' => 'Name-1',
            'type' => 'standard',
            'barcode' => 'barcode',
            'mpn' => 'mpn',
            'weight' => 1.2,
            'weight_unit' => 'lb',
            'length' => 2.4,
            'length_unit' => 'in',
            'width' => 18.8,
            'width_unit' => 'in',
        ],
        [
            'sku' => 'SKU-2',
            'name' => 'Name-2',
            'type' => 'standard',
            'barcode' => 'barcode',
            'mpn' => 'mpn',
            'weight' => 1.2,
            'weight_unit' => 'lb',
            'length' => 2.4,
            'length_unit' => 'in',
            'width' => 18.8,
            'width_unit' => 'in',
        ],
        [
            'sku' => 'SKU-3',
            'name' => 'Name-3',
            'type' => 'standard',
            'barcode' => 'barcode',
            'mpn' => 'mpn',
            'weight' => 1.2,
            'weight_unit' => 'lb',
            'length' => 2.4,
            'length_unit' => 'in',
            'width' => 18.8,
            'width_unit' => 'in',
        ],
    ],
    // 'file_sample'    => asset('FILE_NAME_HERE'),
];
