<?php
/**
 * Created by PhpStorm.
 * User: brightantwiboasiako
 * Date: 11/27/20
 * Time: 3:18 PM.
 */

namespace App\Services\StockTake;

use App\Models\StockTake;
use Throwable;

/**
 * Class OpenStockTakeException.
 */
class OpenStockTakeException extends \Exception
{
    /**
     * @var StockTake
     */
    public $stockTake;

    // Status for stock take error
    public $status = 423;

    /**
     * OpenStockTakeException constructor.
     */
    public function __construct(StockTake $stockTake, string $message = '', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);

        $this->stockTake = $stockTake;
    }
}
