<?php

namespace App\Services\ShippingProvider;

use App\Models\SalesOrderFulfillment;
use Illuminate\Database\Eloquent\Model;

interface ShippingProviderRepository
{
    /**
     * @param  int  $fulfillmentId
     * @return ShippingProviderOrder|Model|null
     */
    public function getOrderByFulfillmentId(int $fulfillmentId): ShippingProviderOrder|Model|null;

    /**
     * @param  string|int  $response
     * @param  SalesOrderFulfillment  $fulfillment
     * @return ShippingProviderOrder|Model
     */
    public function updateOrCreateByResponse(string|int $response, SalesOrderFulfillment $fulfillment): ShippingProviderOrder|Model;

    /**
     * @return array
     */
    public function getOrderIdsNeedingTrackingInfo(): array;

    /**
     * @param  array  $orders
     * @return array
     */
    public function updateAll(array $orders): array;

    /**
     * @param  array  $orders
     * @return mixed
     */
    public function getShippingMethodsIn(array $orders): array;

    /**
     * @param  array  $fulfillmentData
     * @return int
     */
    public function updateFulfillmentsWithTrackingInfo(array $fulfillmentData): int;

    /**
     * @param  array  $orders
     * @return array
     */
    public function getFulfillmentsForOrders(array $orders): array;

    /**
     * @param  array  $ids
     * @return array
     */
    public function findByIds(array $ids): array;
}