<?php

namespace App\Services\SalesOrder\Fulfillments\Dispatchers;

use App\Models\SalesOrderFulfillment;
use App\Services\SalesOrder\Fulfillments\ShipmentDispatcher;
use Illuminate\Contracts\Container\BindingResolutionException;
use InvalidArgumentException;

class ShipmentDispatcherFactory
{
    /**
     * Makes a shipment dispatcher based on the given provider.
     *
     *
     * @throws BindingResolutionException
     */
    public static function make(string $provider): ShipmentDispatcher
    {
        try {
            return match ($provider) {
                // Resolving from the ioc container allows us to mock these objects in tests.
                SalesOrderFulfillment::TYPE_STARSHIPIT => app(SalesOrderFulfillment::TYPE_STARSHIPIT),
                SalesOrderFulfillment::TYPE_SHIPSTATION => app(SalesOrderFulfillment::TYPE_SHIPSTATION),
                SalesOrderFulfillment::TYPE_SHIPMYORDERS => app(SalesOrderFulfillment::TYPE_SHIPMYORDERS),
                SalesOrderFulfillment::TYPE_VERACORE => app(SalesOrderFulfillment::TYPE_VERACORE),
                SalesOrderFulfillment::TYPE_FBA => app(SalesOrderFulfillment::TYPE_FBA),
                default => throw new InvalidArgumentException(
                    'Unsupported shipping provider:  '.$provider
                ),
            };
        } catch (BindingResolutionException $e) {
            throw new BindingResolutionException(
                'Could not find a shipping dispatcher for '.
                $provider.'. Did you register an implementation in the `FulfillmentServiceProvider.php`?',
                previous: $e
            );
        }
    }
}
