<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;
use Illuminate\Contracts\Container\BindingResolutionException;

/**
 * Class PriorityOrder.
 */
abstract class SingleQueuePriorityOrder extends PriorityOrder
{
    protected BackorderQueue $queue;

    /**
     * PriorityOrder constructor.
     *
     *
     * @throws BindingResolutionException
     */
    public function __construct(BackorderQueue $queue, array $options = [])
    {
        $this->queue = $queue;
        parent::__construct($options);
    }

    protected function simplySwapWith(BackorderQueue $queue): BackorderQueue
    {
        $currentPriority = $this->queue->priority;
        $this->queue->setPriority($queue->priority);
        $queue->setPriority($currentPriority);
        $this->swapCoverages($queue, $this->queue);

        return $this->queue;
    }
}
