<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;
use Illuminate\Contracts\Container\BindingResolutionException;
use InvalidArgumentException;

/**
 * Class PriorityOrderFactory.
 */
class PriorityOrderFactory
{
    /**
     * @throws BindingResolutionException
     */
    public static function make(string $type, ?BackorderQueue $queue, array $options = []): PriorityOrder
    {
        if (! in_array($type, BackorderQueue::REORDER_TYPES)) {
            throw new InvalidArgumentException('Unsupported type: '.$type);
        }

        switch ($type) {
            case BackorderQueue::REORDER_TYPE_MOVE_TO_TOP:
                return new MoveToTopSingleQueuePriorityOrder($queue, $options);
            case BackorderQueue::REORDER_TYPE_MOVE_TO_BOTTOM:
                return new MoveToBottomSingleQueuePriorityOrder($queue, $options);
            case BackorderQueue::REORDER_TYPE_MOVE_UP:
                return new MoveUpSingleQueuePriorityOrder($queue, $options);
            case BackorderQueue::REORDER_TYPE_MOVE_DOWN:
                return new MoveDownSingleQueuePriorityOrder($queue, $options);
            case BackorderQueue::REORDER_TYPE_MOVE_ABOVE_ID:
                return new MoveAboveIdPriorityOrder($queue, $options);
            case BackorderQueue::REORDER_TYPE_BULK_MOVE_TO_TOP:
                return new BulkMoveToTopPriorityOrder($options);
            case BackorderQueue::REORDER_TYPE_BULK_MOVE_TO_BOTTOM:
                return new BulkMoveToBottomPriorityOrder($options);
            case BackorderQueue::REORDER_TYPE_BULK_MOVE_ABOVE_ID:
                return new BulkMoveAboveIdPriorityOrder($options);
            default:
                throw new InvalidArgumentException('Unsupported type: '.$type);
        }
    }
}
