<?php

namespace App\Services\SalesOrder\Backorder;

use App\Jobs\SyncBackorderQueueCoveragesJob;
use App\Models\BackorderQueue;
use App\Repositories\BackorderQueueRepository;
use Illuminate\Contracts\Container\BindingResolutionException;
use Throwable;

/**
 * Class PriorityOrder.
 */
abstract class PriorityOrder
{
    protected array $options;

    protected BackorderQueueRepository $queues;

    /**
     * PriorityOrder constructor.
     *
     *
     * @throws BindingResolutionException
     */
    public function __construct(array $options = [])
    {
        $this->options = $options;
        $this->queues = app()->make(BackorderQueueRepository::class);
    }

    /**
     * Swaps the coverages of the backorder layers.
     */
    protected function swapCoverages(BackorderQueue $queue1, BackorderQueue $queue2): void
    {
        $this->queues->swapCoverages($queue1, $queue2);
    }

    /**
     * @return mixed
     */
    abstract public function process();

    /**
     * @throws Throwable
     */
    protected function refreshCoverages(array $queueIds = []): void
    {
        if (empty($queueIds) && (empty($this->options) || ! isset($this->options['ids']))) {
            return;
        }

        foreach ($this->queues->getWarehouseProductsForQueues($this->options['ids'] + $queueIds) as $warehouseId => $results) {
            dispatch(new SyncBackorderQueueCoveragesJob(null, null, collect($results)->pluck('product_id')->toArray(), $warehouseId));
        }
    }
}
