<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;

/**
 * Class MoveUpPriorityOrder.
 */
class MoveUpSingleQueuePriorityOrder extends SingleQueuePriorityOrder
{
    public function process(): BackorderQueue
    {
        // Swap priorities with previous
        // E.g from priority 5 -> 4
        $previous = $this->queues->firstBeforePriority($this->queue->priority, $this->queue->getProductId());
        if ($previous) {
            // We swap the priorities
            $this->simplySwapWith($previous);
        }

        return $this->queue;
    }
}
