<?php

namespace App\Services\SalesOrder\Backorder;

class MoveToTopSingleQueuePriorityOrder extends SingleQueuePriorityOrder
{
    public function process()
    {
        $firstPriority = $this->queues->firstPriority($this->queue->getProductId());
        if ($firstPriority && $firstPriority->id != $this->queue->id) {
            $currentPriority = $this->queue->priority;
            // Increment priorities by 1 except this queue
            $this->queues->incrementPrioritiesBefore($currentPriority, $this->queue->getProductId(), 1, [$this->queue->id]);
            $this->queue->setPriority(1);

            /**
             * Refresh to reflect the updated priority
             * of the first priority queue.
             */
            $this->swapCoverages($firstPriority->refresh(), $this->queue);
        }

        return $this->queue;
    }
}
