<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;

/**
 * Class MoveDownPriorityOrder.
 */
class MoveDownSingleQueuePriorityOrder extends SingleQueuePriorityOrder
{
    public function process(): BackorderQueue
    {
        // Swap priorities with next
        $next = $this->queues->firstAfterPriority($this->queue->priority, $this->queue->getProductId());
        if ($next) {
            // We swap the priorities
            $this->simplySwapWith($next);
        }

        return $this->queue;
    }
}
