<?php

namespace App\Services\SalesOrder\Backorder;

use App\Models\BackorderQueue;
use InvalidArgumentException;

/**
 * Class MoveAboveIdPriorityOrder.
 */
class MoveAboveIdPriorityOrder extends MoveUpSingleQueuePriorityOrder
{
    /**
     * @return BackorderQueue|void
     */
    public function process()
    {
        if (empty($this->options) || ! isset($this->options['id'])) {
            throw new InvalidArgumentException('id option is required.');
        }

        $queue = $this->queues->findById($this->options['id']);
        if ($queue && $queue->id != $this->queue->id) {
            /**
             * i = priority of what's being moved (the queue object)
             * j = priority of the reference queue.
             *
             * i < j:
             *      1. Decrement priorities (i+1) to (j-1)
             *      2. Set i to j-1
             *
             * i > j:
             *      1. Increment priorities j to (i-1)
             *      2. Set i to j
             */
            $i = $this->queue->priority;
            $j = $queue->priority;

            if (abs($i - $j) === 1) {
                if ($i < $j) {
                    // The queue is already above the given id
                    return $this->queue;
                } else {
                    // Simply swap adjacent queues
                    return $this->simplySwapWith($queue);
                }
            }

            if ($i < $j) {
                $this->queues->decrementPrioritiesBetween($i + 1, $j - 1, $this->queue->getProductId(), 1, [$this->queue->id]);
                $this->queue->setPriority($j - 1);
            } else {
                $this->queues->incrementPrioritiesBetween($j, $i - 1, $this->queue->getProductId(), 1, [$this->queue->id]);
                $this->queue->setPriority($j);
            }
        }

        return $this->queue;
    }
}
